package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  ObjectStorageServerPort,
  ObjectStorageAccessKey,
  LocationArn,
  ObjectStorageSecretKey,
  S3Subdirectory,
  AgentArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateLocationObjectStorageRequest(
    locationArn: LocationArn,
    serverPort: Optional[ObjectStorageServerPort] = Optional.Absent,
    serverProtocol: Optional[
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = Optional.Absent,
    subdirectory: Optional[S3Subdirectory] = Optional.Absent,
    accessKey: Optional[ObjectStorageAccessKey] = Optional.Absent,
    secretKey: Optional[ObjectStorageSecretKey] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest = {
    import UpdateLocationObjectStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        serverPort.map(value => ObjectStorageServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        accessKey.map(value =>
          ObjectStorageAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .optionallyWith(
        secretKey.map(value =>
          ObjectStorageSecretKey.unwrap(value): java.lang.String
        )
      )(_.secretKey)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationObjectStorageRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationObjectStorageRequest
      .wrap(buildAwsValue())
}
object UpdateLocationObjectStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationObjectStorageRequest =
      zio.aws.datasync.model.UpdateLocationObjectStorageRequest(
        locationArn,
        serverPort.map(value => value),
        serverProtocol.map(value => value),
        subdirectory.map(value => value),
        accessKey.map(value => value),
        secretKey.map(value => value),
        agentArns.map(value => value)
      )
    def locationArn: LocationArn
    def serverPort: Optional[ObjectStorageServerPort]
    def serverProtocol
        : Optional[zio.aws.datasync.model.ObjectStorageServerProtocol]
    def subdirectory: Optional[S3Subdirectory]
    def accessKey: Optional[ObjectStorageAccessKey]
    def secretKey: Optional[ObjectStorageSecretKey]
    def agentArns: Optional[List[AgentArn]]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getServerPort: ZIO[Any, AwsError, ObjectStorageServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
    def getServerProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getAccessKey: ZIO[Any, AwsError, ObjectStorageAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getSecretKey: ZIO[Any, AwsError, ObjectStorageSecretKey] =
      AwsError.unwrapOptionField("secretKey", secretKey)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
  ) extends zio.aws.datasync.model.UpdateLocationObjectStorageRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val serverPort: Optional[ObjectStorageServerPort] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverPort())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageServerPort(value)
        )
    override val serverProtocol
        : Optional[zio.aws.datasync.model.ObjectStorageServerProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverProtocol())
        .map(value =>
          zio.aws.datasync.model.ObjectStorageServerProtocol.wrap(value)
        )
    override val subdirectory: Optional[S3Subdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val accessKey: Optional[ObjectStorageAccessKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKey())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageAccessKey(value)
        )
    override val secretKey: Optional[ObjectStorageSecretKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretKey())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageSecretKey(value)
        )
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
  ): zio.aws.datasync.model.UpdateLocationObjectStorageRequest.ReadOnly =
    new Wrapper(impl)
}
