package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  SmbUser,
  SmbSubdirectory,
  SmbPassword,
  SmbDomain,
  ServerHostname,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationSmbRequest(
    subdirectory: SmbSubdirectory,
    serverHostname: ServerHostname,
    user: SmbUser,
    domain: Optional[SmbDomain] = Optional.Absent,
    password: SmbPassword,
    agentArns: Iterable[AgentArn],
    mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest = {
    import CreateLocationSmbRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
      .builder()
      .subdirectory(SmbSubdirectory.unwrap(subdirectory): java.lang.String)
      .serverHostname(ServerHostname.unwrap(serverHostname): java.lang.String)
      .user(SmbUser.unwrap(user): java.lang.String)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .password(SmbPassword.unwrap(password): java.lang.String)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationSmbRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationSmbRequest.wrap(buildAwsValue())
}
object CreateLocationSmbRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationSmbRequest =
      zio.aws.datasync.model.CreateLocationSmbRequest(
        subdirectory,
        serverHostname,
        user,
        domain.map(value => value),
        password,
        agentArns,
        mountOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subdirectory: SmbSubdirectory
    def serverHostname: ServerHostname
    def user: SmbUser
    def domain: Optional[SmbDomain]
    def password: SmbPassword
    def agentArns: List[AgentArn]
    def mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getSubdirectory: ZIO[Any, Nothing, SmbSubdirectory] =
      ZIO.succeed(subdirectory)
    def getServerHostname: ZIO[Any, Nothing, ServerHostname] =
      ZIO.succeed(serverHostname)
    def getUser: ZIO[Any, Nothing, SmbUser] = ZIO.succeed(user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getPassword: ZIO[Any, Nothing, SmbPassword] = ZIO.succeed(password)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
  ) extends zio.aws.datasync.model.CreateLocationSmbRequest.ReadOnly {
    override val subdirectory: SmbSubdirectory =
      zio.aws.datasync.model.primitives.SmbSubdirectory(impl.subdirectory())
    override val serverHostname: ServerHostname =
      zio.aws.datasync.model.primitives.ServerHostname(impl.serverHostname())
    override val user: SmbUser =
      zio.aws.datasync.model.primitives.SmbUser(impl.user())
    override val domain: Optional[SmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val password: SmbPassword =
      zio.aws.datasync.model.primitives.SmbPassword(impl.password())
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val mountOptions
        : Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
  ): zio.aws.datasync.model.CreateLocationSmbRequest.ReadOnly = new Wrapper(
    impl
  )
}
