package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{NfsSubdirectory, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationNfsRequest(
    locationArn: LocationArn,
    subdirectory: Optional[NfsSubdirectory] = Optional.Absent,
    onPremConfig: Optional[zio.aws.datasync.model.OnPremConfig] =
      Optional.Absent,
    mountOptions: Optional[zio.aws.datasync.model.NfsMountOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest = {
    import UpdateLocationNfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          NfsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(onPremConfig.map(value => value.buildAwsValue()))(
        _.onPremConfig
      )
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateLocationNfsRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationNfsRequest.wrap(buildAwsValue())
}
object UpdateLocationNfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationNfsRequest =
      zio.aws.datasync.model.UpdateLocationNfsRequest(
        locationArn,
        subdirectory.map(value => value),
        onPremConfig.map(value => value.asEditable),
        mountOptions.map(value => value.asEditable)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[NfsSubdirectory]
    def onPremConfig: Optional[zio.aws.datasync.model.OnPremConfig.ReadOnly]
    def mountOptions: Optional[zio.aws.datasync.model.NfsMountOptions.ReadOnly]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, NfsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getOnPremConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.OnPremConfig.ReadOnly] =
      AwsError.unwrapOptionField("onPremConfig", onPremConfig)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest
  ) extends zio.aws.datasync.model.UpdateLocationNfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[NfsSubdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.NfsSubdirectory(value))
    override val onPremConfig
        : Optional[zio.aws.datasync.model.OnPremConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPremConfig())
        .map(value => zio.aws.datasync.model.OnPremConfig.wrap(value))
    override val mountOptions
        : Optional[zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.NfsMountOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest
  ): zio.aws.datasync.model.UpdateLocationNfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
