package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTaskResponse(
    taskArn: Optional[TaskArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateTaskResponse = {
    import CreateTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateTaskResponse
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateTaskResponse.ReadOnly =
    zio.aws.datasync.model.CreateTaskResponse.wrap(buildAwsValue())
}
object CreateTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateTaskResponse =
      zio.aws.datasync.model.CreateTaskResponse(taskArn.map(value => value))
    def taskArn: Optional[TaskArn]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateTaskResponse
  ) extends zio.aws.datasync.model.CreateTaskResponse.ReadOnly {
    override val taskArn: Optional[TaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateTaskResponse
  ): zio.aws.datasync.model.CreateTaskResponse.ReadOnly = new Wrapper(impl)
}
