package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  Ec2SecurityGroupArn,
  LocationUri,
  LocationArn
}
import scala.jdk.CollectionConverters._
final case class DescribeLocationFsxOpenZfsResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    securityGroupArns: Optional[Iterable[Ec2SecurityGroupArn]] =
      Optional.Absent,
    protocol: Optional[zio.aws.datasync.model.FsxProtocol] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse = {
    import DescribeLocationFsxOpenZfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .optionallyWith(protocol.map(value => value.buildAwsValue()))(_.protocol)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse
      .wrap(buildAwsValue())
}
object DescribeLocationFsxOpenZfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse =
      zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        securityGroupArns.map(value => value),
        protocol.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def securityGroupArns: Optional[List[Ec2SecurityGroupArn]]
    def protocol: Optional[zio.aws.datasync.model.FsxProtocol.ReadOnly]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse
  ) extends zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val securityGroupArns: Optional[List[Ec2SecurityGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
          }.toList
        )
    override val protocol
        : Optional[zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.datasync.model.FsxProtocol.wrap(value))
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse
  ): zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly =
    new Wrapper(impl)
}
