package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{Time, TaskExecutionArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeTaskExecutionResponse(
    taskExecutionArn: Option[TaskExecutionArn] = None,
    status: Option[zio.aws.datasync.model.TaskExecutionStatus] = None,
    options: Option[zio.aws.datasync.model.Options] = None,
    excludes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None,
    includes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None,
    startTime: Option[Time] = None,
    estimatedFilesToTransfer: Option[Long] = None,
    estimatedBytesToTransfer: Option[Long] = None,
    filesTransferred: Option[Long] = None,
    bytesWritten: Option[Long] = None,
    bytesTransferred: Option[Long] = None,
    result: Option[zio.aws.datasync.model.TaskExecutionResultDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse = {
    import DescribeTaskExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
      .builder()
      .optionallyWith(
        taskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.taskExecutionArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(startTime.map(value => Time.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        estimatedFilesToTransfer.map(value => value: java.lang.Long)
      )(_.estimatedFilesToTransfer)
      .optionallyWith(
        estimatedBytesToTransfer.map(value => value: java.lang.Long)
      )(_.estimatedBytesToTransfer)
      .optionallyWith(filesTransferred.map(value => value: java.lang.Long))(
        _.filesTransferred
      )
      .optionallyWith(bytesWritten.map(value => value: java.lang.Long))(
        _.bytesWritten
      )
      .optionallyWith(bytesTransferred.map(value => value: java.lang.Long))(
        _.bytesTransferred
      )
      .optionallyWith(result.map(value => value.buildAwsValue()))(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly =
    zio.aws.datasync.model.DescribeTaskExecutionResponse.wrap(buildAwsValue())
}
object DescribeTaskExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeTaskExecutionResponse =
      zio.aws.datasync.model.DescribeTaskExecutionResponse(
        taskExecutionArn.map(value => value),
        status.map(value => value),
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime.map(value => value),
        estimatedFilesToTransfer.map(value => value),
        estimatedBytesToTransfer.map(value => value),
        filesTransferred.map(value => value),
        bytesWritten.map(value => value),
        bytesTransferred.map(value => value),
        result.map(value => value.asEditable)
      )
    def taskExecutionArn: Option[TaskExecutionArn]
    def status: Option[zio.aws.datasync.model.TaskExecutionStatus]
    def options: Option[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def includes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def startTime: Option[Time]
    def estimatedFilesToTransfer: Option[Long]
    def estimatedBytesToTransfer: Option[Long]
    def filesTransferred: Option[Long]
    def bytesWritten: Option[Long]
    def bytesTransferred: Option[Long]
    def result
        : Option[zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly]
    def getTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField("taskExecutionArn", taskExecutionArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEstimatedFilesToTransfer: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("estimatedFilesToTransfer", estimatedFilesToTransfer)
    def getEstimatedBytesToTransfer: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("estimatedBytesToTransfer", estimatedBytesToTransfer)
    def getFilesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("filesTransferred", filesTransferred)
    def getBytesWritten: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesWritten", bytesWritten)
    def getBytesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesTransferred", bytesTransferred)
    def getResult: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly
    ] = AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
  ) extends zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly {
    override val taskExecutionArn: Option[TaskExecutionArn] = scala
      .Option(impl.taskExecutionArn())
      .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
    override val status: Option[zio.aws.datasync.model.TaskExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.datasync.model.TaskExecutionStatus.wrap(value))
    override val options: Option[zio.aws.datasync.model.Options.ReadOnly] =
      scala
        .Option(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.excludes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
    override val includes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.includes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
    override val startTime: Option[Time] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val estimatedFilesToTransfer: Option[Long] =
      scala.Option(impl.estimatedFilesToTransfer()).map(value => value: Long)
    override val estimatedBytesToTransfer: Option[Long] =
      scala.Option(impl.estimatedBytesToTransfer()).map(value => value: Long)
    override val filesTransferred: Option[Long] =
      scala.Option(impl.filesTransferred()).map(value => value: Long)
    override val bytesWritten: Option[Long] =
      scala.Option(impl.bytesWritten()).map(value => value: Long)
    override val bytesTransferred: Option[Long] =
      scala.Option(impl.bytesTransferred()).map(value => value: Long)
    override val result
        : Option[zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly] =
      scala
        .Option(impl.result())
        .map(value =>
          zio.aws.datasync.model.TaskExecutionResultDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
  ): zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
