package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait EndpointType {
  def unwrap: software.amazon.awssdk.services.datasync.model.EndpointType
}
object EndpointType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.EndpointType
  ): zio.aws.datasync.model.EndpointType = value match {
    case software.amazon.awssdk.services.datasync.model.EndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.EndpointType.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.datasync.model.EndpointType.PRIVATE_LINK =>
      val r = PRIVATE_LINK
      r
    case software.amazon.awssdk.services.datasync.model.EndpointType.FIPS =>
      val r = FIPS
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EndpointType =
      software.amazon.awssdk.services.datasync.model.EndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.datasync.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EndpointType =
      software.amazon.awssdk.services.datasync.model.EndpointType.PUBLIC
  }
  case object PRIVATE_LINK extends zio.aws.datasync.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EndpointType =
      software.amazon.awssdk.services.datasync.model.EndpointType.PRIVATE_LINK
  }
  case object FIPS extends zio.aws.datasync.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EndpointType =
      software.amazon.awssdk.services.datasync.model.EndpointType.FIPS
  }
}
