package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait Mtime {
  def unwrap: software.amazon.awssdk.services.datasync.model.Mtime
}
object Mtime {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.Mtime
  ): zio.aws.datasync.model.Mtime = value match {
    case software.amazon.awssdk.services.datasync.model.Mtime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.Mtime.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.Mtime.PRESERVE =>
      val r = PRESERVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.Mtime {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Mtime =
      software.amazon.awssdk.services.datasync.model.Mtime.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.Mtime {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Mtime =
      software.amazon.awssdk.services.datasync.model.Mtime.NONE
  }
  case object PRESERVE extends zio.aws.datasync.model.Mtime {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Mtime =
      software.amazon.awssdk.services.datasync.model.Mtime.PRESERVE
  }
}
