package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{Time, LocationUri, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeLocationEfsResponse(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None,
    ec2Config: Option[zio.aws.datasync.model.Ec2Config] = None,
    creationTime: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse = {
    import DescribeLocationEfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(ec2Config.map(value => value.buildAwsValue()))(
        _.ec2Config
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationEfsResponse.wrap(buildAwsValue())
}
object DescribeLocationEfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationEfsResponse =
      zio.aws.datasync.model.DescribeLocationEfsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        ec2Config.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def ec2Config: Option[zio.aws.datasync.model.Ec2Config.ReadOnly]
    def creationTime: Option[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getEc2Config
        : ZIO[Any, AwsError, zio.aws.datasync.model.Ec2Config.ReadOnly] =
      AwsError.unwrapOptionField("ec2Config", ec2Config)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse
  ) extends zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val ec2Config: Option[zio.aws.datasync.model.Ec2Config.ReadOnly] =
      scala
        .Option(impl.ec2Config())
        .map(value => zio.aws.datasync.model.Ec2Config.wrap(value))
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse
  ): zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
