package zio.aws.datasync.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  LocationArn,
  KerberosPrincipal,
  HdfsReplicationFactor,
  HdfsUser,
  LocationUri,
  KmsKeyProviderUri,
  AgentArn,
  HdfsBlockSize
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLocationHdfsResponse(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None,
    nameNodes: Option[Iterable[zio.aws.datasync.model.HdfsNameNode]] = None,
    blockSize: Option[HdfsBlockSize] = None,
    replicationFactor: Option[HdfsReplicationFactor] = None,
    kmsKeyProviderUri: Option[KmsKeyProviderUri] = None,
    qopConfiguration: Option[zio.aws.datasync.model.QopConfiguration] = None,
    authenticationType: Option[zio.aws.datasync.model.HdfsAuthenticationType] =
      None,
    simpleUser: Option[HdfsUser] = None,
    kerberosPrincipal: Option[KerberosPrincipal] = None,
    agentArns: Option[Iterable[AgentArn]] = None,
    creationTime: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse = {
    import DescribeLocationHdfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        nameNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nameNodes)
      .optionallyWith(
        blockSize.map(value => HdfsBlockSize.unwrap(value): Integer)
      )(_.blockSize)
      .optionallyWith(
        replicationFactor.map(value =>
          HdfsReplicationFactor.unwrap(value): Integer
        )
      )(_.replicationFactor)
      .optionallyWith(
        kmsKeyProviderUri.map(value =>
          KmsKeyProviderUri.unwrap(value): java.lang.String
        )
      )(_.kmsKeyProviderUri)
      .optionallyWith(qopConfiguration.map(value => value.buildAwsValue()))(
        _.qopConfiguration
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        simpleUser.map(value => HdfsUser.unwrap(value): java.lang.String)
      )(_.simpleUser)
      .optionallyWith(
        kerberosPrincipal.map(value =>
          KerberosPrincipal.unwrap(value): java.lang.String
        )
      )(_.kerberosPrincipal)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationHdfsResponse.wrap(buildAwsValue())
}
object DescribeLocationHdfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationHdfsResponse =
      zio.aws.datasync.model.DescribeLocationHdfsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        nameNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blockSize.map(value => value),
        replicationFactor.map(value => value),
        kmsKeyProviderUri.map(value => value),
        qopConfiguration.map(value => value.asEditable),
        authenticationType.map(value => value),
        simpleUser.map(value => value),
        kerberosPrincipal.map(value => value),
        agentArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def nameNodes: Option[List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]]
    def blockSize: Option[HdfsBlockSize]
    def replicationFactor: Option[HdfsReplicationFactor]
    def kmsKeyProviderUri: Option[KmsKeyProviderUri]
    def qopConfiguration
        : Option[zio.aws.datasync.model.QopConfiguration.ReadOnly]
    def authenticationType
        : Option[zio.aws.datasync.model.HdfsAuthenticationType]
    def simpleUser: Option[HdfsUser]
    def kerberosPrincipal: Option[KerberosPrincipal]
    def agentArns: Option[List[AgentArn]]
    def creationTime: Option[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getNameNodes: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.HdfsNameNode.ReadOnly
    ]] = AwsError.unwrapOptionField("nameNodes", nameNodes)
    def getBlockSize: ZIO[Any, AwsError, HdfsBlockSize] =
      AwsError.unwrapOptionField("blockSize", blockSize)
    def getReplicationFactor: ZIO[Any, AwsError, HdfsReplicationFactor] =
      AwsError.unwrapOptionField("replicationFactor", replicationFactor)
    def getKmsKeyProviderUri: ZIO[Any, AwsError, KmsKeyProviderUri] =
      AwsError.unwrapOptionField("kmsKeyProviderUri", kmsKeyProviderUri)
    def getQopConfiguration
        : ZIO[Any, AwsError, zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("qopConfiguration", qopConfiguration)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.datasync.model.HdfsAuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getSimpleUser: ZIO[Any, AwsError, HdfsUser] =
      AwsError.unwrapOptionField("simpleUser", simpleUser)
    def getKerberosPrincipal: ZIO[Any, AwsError, KerberosPrincipal] =
      AwsError.unwrapOptionField("kerberosPrincipal", kerberosPrincipal)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
  ) extends zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val nameNodes
        : Option[List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]] = scala
      .Option(impl.nameNodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.HdfsNameNode.wrap(item)
        }.toList
      )
    override val blockSize: Option[HdfsBlockSize] = scala
      .Option(impl.blockSize())
      .map(value => zio.aws.datasync.model.primitives.HdfsBlockSize(value))
    override val replicationFactor: Option[HdfsReplicationFactor] = scala
      .Option(impl.replicationFactor())
      .map(value =>
        zio.aws.datasync.model.primitives.HdfsReplicationFactor(value)
      )
    override val kmsKeyProviderUri: Option[KmsKeyProviderUri] = scala
      .Option(impl.kmsKeyProviderUri())
      .map(value => zio.aws.datasync.model.primitives.KmsKeyProviderUri(value))
    override val qopConfiguration
        : Option[zio.aws.datasync.model.QopConfiguration.ReadOnly] = scala
      .Option(impl.qopConfiguration())
      .map(value => zio.aws.datasync.model.QopConfiguration.wrap(value))
    override val authenticationType
        : Option[zio.aws.datasync.model.HdfsAuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value => zio.aws.datasync.model.HdfsAuthenticationType.wrap(value))
    override val simpleUser: Option[HdfsUser] = scala
      .Option(impl.simpleUser())
      .map(value => zio.aws.datasync.model.primitives.HdfsUser(value))
    override val kerberosPrincipal: Option[KerberosPrincipal] = scala
      .Option(impl.kerberosPrincipal())
      .map(value => zio.aws.datasync.model.primitives.KerberosPrincipal(value))
    override val agentArns: Option[List[AgentArn]] = scala
      .Option(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
  ): zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
