package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  Time,
  TaskExecutionArn,
  LocationArn,
  TagValue,
  TaskArn,
  LogGroupArn,
  NetworkInterfaceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeTaskResponse(
    taskArn: Option[TaskArn] = None,
    status: Option[zio.aws.datasync.model.TaskStatus] = None,
    name: Option[TagValue] = None,
    currentTaskExecutionArn: Option[TaskExecutionArn] = None,
    sourceLocationArn: Option[LocationArn] = None,
    destinationLocationArn: Option[LocationArn] = None,
    cloudWatchLogGroupArn: Option[LogGroupArn] = None,
    sourceNetworkInterfaceArns: Option[Iterable[NetworkInterfaceArn]] = None,
    destinationNetworkInterfaceArns: Option[Iterable[NetworkInterfaceArn]] =
      None,
    options: Option[zio.aws.datasync.model.Options] = None,
    excludes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None,
    schedule: Option[zio.aws.datasync.model.TaskSchedule] = None,
    errorCode: Option[String] = None,
    errorDetail: Option[String] = None,
    creationTime: Option[Time] = None,
    includes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeTaskResponse = {
    import DescribeTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        currentTaskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.currentTaskExecutionArn)
      .optionallyWith(
        sourceLocationArn.map(value =>
          LocationArn.unwrap(value): java.lang.String
        )
      )(_.sourceLocationArn)
      .optionallyWith(
        destinationLocationArn.map(value =>
          LocationArn.unwrap(value): java.lang.String
        )
      )(_.destinationLocationArn)
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        sourceNetworkInterfaceArns.map(value =>
          value.map { item =>
            NetworkInterfaceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceNetworkInterfaceArns)
      .optionallyWith(
        destinationNetworkInterfaceArns.map(value =>
          value.map { item =>
            NetworkInterfaceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinationNetworkInterfaceArns)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetail.map(value => value: java.lang.String))(
        _.errorDetail
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeTaskResponse.ReadOnly =
    zio.aws.datasync.model.DescribeTaskResponse.wrap(buildAwsValue())
}
object DescribeTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeTaskResponse =
      zio.aws.datasync.model.DescribeTaskResponse(
        taskArn.map(value => value),
        status.map(value => value),
        name.map(value => value),
        currentTaskExecutionArn.map(value => value),
        sourceLocationArn.map(value => value),
        destinationLocationArn.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        sourceNetworkInterfaceArns.map(value => value),
        destinationNetworkInterfaceArns.map(value => value),
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable),
        errorCode.map(value => value),
        errorDetail.map(value => value),
        creationTime.map(value => value),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskArn: Option[TaskArn]
    def status: Option[zio.aws.datasync.model.TaskStatus]
    def name: Option[TagValue]
    def currentTaskExecutionArn: Option[TaskExecutionArn]
    def sourceLocationArn: Option[LocationArn]
    def destinationLocationArn: Option[LocationArn]
    def cloudWatchLogGroupArn: Option[LogGroupArn]
    def sourceNetworkInterfaceArns: Option[List[NetworkInterfaceArn]]
    def destinationNetworkInterfaceArns: Option[List[NetworkInterfaceArn]]
    def options: Option[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def schedule: Option[zio.aws.datasync.model.TaskSchedule.ReadOnly]
    def errorCode: Option[String]
    def errorDetail: Option[String]
    def creationTime: Option[Time]
    def includes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getCurrentTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField(
        "currentTaskExecutionArn",
        currentTaskExecutionArn
      )
    def getSourceLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("sourceLocationArn", sourceLocationArn)
    def getDestinationLocationArn: ZIO[Any, AwsError, LocationArn] = AwsError
      .unwrapOptionField("destinationLocationArn", destinationLocationArn)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getSourceNetworkInterfaceArns
        : ZIO[Any, AwsError, List[NetworkInterfaceArn]] =
      AwsError.unwrapOptionField(
        "sourceNetworkInterfaceArns",
        sourceNetworkInterfaceArns
      )
    def getDestinationNetworkInterfaceArns
        : ZIO[Any, AwsError, List[NetworkInterfaceArn]] =
      AwsError.unwrapOptionField(
        "destinationNetworkInterfaceArns",
        destinationNetworkInterfaceArns
      )
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetail", errorDetail)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
  ) extends zio.aws.datasync.model.DescribeTaskResponse.ReadOnly {
    override val taskArn: Option[TaskArn] = scala
      .Option(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
    override val status: Option[zio.aws.datasync.model.TaskStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.datasync.model.TaskStatus.wrap(value))
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val currentTaskExecutionArn: Option[TaskExecutionArn] = scala
      .Option(impl.currentTaskExecutionArn())
      .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
    override val sourceLocationArn: Option[LocationArn] = scala
      .Option(impl.sourceLocationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val destinationLocationArn: Option[LocationArn] = scala
      .Option(impl.destinationLocationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val cloudWatchLogGroupArn: Option[LogGroupArn] = scala
      .Option(impl.cloudWatchLogGroupArn())
      .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val sourceNetworkInterfaceArns: Option[List[NetworkInterfaceArn]] =
      scala
        .Option(impl.sourceNetworkInterfaceArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.NetworkInterfaceArn(item)
          }.toList
        )
    override val destinationNetworkInterfaceArns
        : Option[List[NetworkInterfaceArn]] = scala
      .Option(impl.destinationNetworkInterfaceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.NetworkInterfaceArn(item)
        }.toList
      )
    override val options: Option[zio.aws.datasync.model.Options.ReadOnly] =
      scala
        .Option(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.excludes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
    override val schedule
        : Option[zio.aws.datasync.model.TaskSchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.datasync.model.TaskSchedule.wrap(value))
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorDetail: Option[String] =
      scala.Option(impl.errorDetail()).map(value => value: String)
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val includes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.includes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
  ): zio.aws.datasync.model.DescribeTaskResponse.ReadOnly = new Wrapper(impl)
}
