package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait HdfsDataTransferProtection {
  def unwrap: software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection
}
object HdfsDataTransferProtection {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection
  ): zio.aws.datasync.model.HdfsDataTransferProtection = value match {
    case software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.AUTHENTICATION =>
      val r = AUTHENTICATION
      r
    case software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.INTEGRITY =>
      val r = INTEGRITY
      r
    case software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.PRIVACY =>
      val r = PRIVACY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.HdfsDataTransferProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection =
      software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED
      extends zio.aws.datasync.model.HdfsDataTransferProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection =
      software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.DISABLED
  }
  case object AUTHENTICATION
      extends zio.aws.datasync.model.HdfsDataTransferProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection =
      software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.AUTHENTICATION
  }
  case object INTEGRITY
      extends zio.aws.datasync.model.HdfsDataTransferProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection =
      software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.INTEGRITY
  }
  case object PRIVACY
      extends zio.aws.datasync.model.HdfsDataTransferProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection =
      software.amazon.awssdk.services.datasync.model.HdfsDataTransferProtection.PRIVACY
  }
}
