package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  ActivationKey,
  TagValue,
  Ec2SubnetArn,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAgentRequest(
    activationKey: ActivationKey,
    agentName: Option[TagValue] = None,
    tags: Option[Iterable[zio.aws.datasync.model.TagListEntry]] = None,
    vpcEndpointId: Option[VpcEndpointId] = None,
    subnetArns: Option[Iterable[Ec2SubnetArn]] = None,
    securityGroupArns: Option[Iterable[Ec2SecurityGroupArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateAgentRequest = {
    import CreateAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateAgentRequest
      .builder()
      .activationKey(ActivationKey.unwrap(activationKey): java.lang.String)
      .optionallyWith(
        agentName.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.agentName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        subnetArns.map(value =>
          value.map { item =>
            Ec2SubnetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetArns)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateAgentRequest.ReadOnly =
    zio.aws.datasync.model.CreateAgentRequest.wrap(buildAwsValue())
}
object CreateAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateAgentRequest =
      zio.aws.datasync.model.CreateAgentRequest(
        activationKey,
        agentName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpointId.map(value => value),
        subnetArns.map(value => value),
        securityGroupArns.map(value => value)
      )
    def activationKey: ActivationKey
    def agentName: Option[TagValue]
    def tags: Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def vpcEndpointId: Option[VpcEndpointId]
    def subnetArns: Option[List[Ec2SubnetArn]]
    def securityGroupArns: Option[List[Ec2SecurityGroupArn]]
    def getActivationKey: ZIO[Any, Nothing, ActivationKey] =
      ZIO.succeed(activationKey)
    def getAgentName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("agentName", agentName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getSubnetArns: ZIO[Any, AwsError, List[Ec2SubnetArn]] =
      AwsError.unwrapOptionField("subnetArns", subnetArns)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateAgentRequest
  ) extends zio.aws.datasync.model.CreateAgentRequest.ReadOnly {
    override val activationKey: ActivationKey =
      zio.aws.datasync.model.primitives.ActivationKey(impl.activationKey())
    override val agentName: Option[TagValue] = scala
      .Option(impl.agentName())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val tags
        : Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TagListEntry.wrap(item)
        }.toList
      )
    override val vpcEndpointId: Option[VpcEndpointId] = scala
      .Option(impl.vpcEndpointId())
      .map(value => zio.aws.datasync.model.primitives.VpcEndpointId(value))
    override val subnetArns: Option[List[Ec2SubnetArn]] = scala
      .Option(impl.subnetArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.Ec2SubnetArn(item)
        }.toList
      )
    override val securityGroupArns: Option[List[Ec2SecurityGroupArn]] = scala
      .Option(impl.securityGroupArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateAgentRequest
  ): zio.aws.datasync.model.CreateAgentRequest.ReadOnly = new Wrapper(impl)
}
