package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TaskExecutionListEntry(
    taskExecutionArn: Option[TaskExecutionArn] = None,
    status: Option[zio.aws.datasync.model.TaskExecutionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry = {
    import TaskExecutionListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
      .builder()
      .optionallyWith(
        taskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.taskExecutionArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly =
    zio.aws.datasync.model.TaskExecutionListEntry.wrap(buildAwsValue())
}
object TaskExecutionListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskExecutionListEntry =
      zio.aws.datasync.model.TaskExecutionListEntry(
        taskExecutionArn.map(value => value),
        status.map(value => value)
      )
    def taskExecutionArn: Option[TaskExecutionArn]
    def status: Option[zio.aws.datasync.model.TaskExecutionStatus]
    def getTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField("taskExecutionArn", taskExecutionArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
  ) extends zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly {
    override val taskExecutionArn: Option[TaskExecutionArn] = scala
      .Option(impl.taskExecutionArn())
      .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
    override val status: Option[zio.aws.datasync.model.TaskExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.datasync.model.TaskExecutionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
  ): zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly = new Wrapper(impl)
}
