package zio.aws.datasync.model
import java.lang.Integer
import zio.aws.datasync.model.primitives.{NextToken, MaxResults, TaskArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTaskExecutionsRequest(
    taskArn: Option[TaskArn] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest = {
    import ListTaskExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListTaskExecutionsRequest.ReadOnly =
    zio.aws.datasync.model.ListTaskExecutionsRequest.wrap(buildAwsValue())
}
object ListTaskExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListTaskExecutionsRequest =
      zio.aws.datasync.model.ListTaskExecutionsRequest(
        taskArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskArn: Option[TaskArn]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
  ) extends zio.aws.datasync.model.ListTaskExecutionsRequest.ReadOnly {
    override val taskArn: Option[TaskArn] = scala
      .Option(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.datasync.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
  ): zio.aws.datasync.model.ListTaskExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
