package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.BytesPerSecond
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Options(
    verifyMode: Option[zio.aws.datasync.model.VerifyMode] = None,
    overwriteMode: Option[zio.aws.datasync.model.OverwriteMode] = None,
    atime: Option[zio.aws.datasync.model.Atime] = None,
    mtime: Option[zio.aws.datasync.model.Mtime] = None,
    uid: Option[zio.aws.datasync.model.Uid] = None,
    gid: Option[zio.aws.datasync.model.Gid] = None,
    preserveDeletedFiles: Option[zio.aws.datasync.model.PreserveDeletedFiles] =
      None,
    preserveDevices: Option[zio.aws.datasync.model.PreserveDevices] = None,
    posixPermissions: Option[zio.aws.datasync.model.PosixPermissions] = None,
    bytesPerSecond: Option[BytesPerSecond] = None,
    taskQueueing: Option[zio.aws.datasync.model.TaskQueueing] = None,
    logLevel: Option[zio.aws.datasync.model.LogLevel] = None,
    transferMode: Option[zio.aws.datasync.model.TransferMode] = None,
    securityDescriptorCopyFlags: Option[
      zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Options = {
    import Options.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Options
      .builder()
      .optionallyWith(verifyMode.map(value => value.unwrap))(_.verifyMode)
      .optionallyWith(overwriteMode.map(value => value.unwrap))(_.overwriteMode)
      .optionallyWith(atime.map(value => value.unwrap))(_.atime)
      .optionallyWith(mtime.map(value => value.unwrap))(_.mtime)
      .optionallyWith(uid.map(value => value.unwrap))(_.uid)
      .optionallyWith(gid.map(value => value.unwrap))(_.gid)
      .optionallyWith(preserveDeletedFiles.map(value => value.unwrap))(
        _.preserveDeletedFiles
      )
      .optionallyWith(preserveDevices.map(value => value.unwrap))(
        _.preserveDevices
      )
      .optionallyWith(posixPermissions.map(value => value.unwrap))(
        _.posixPermissions
      )
      .optionallyWith(
        bytesPerSecond.map(value =>
          BytesPerSecond.unwrap(value): java.lang.Long
        )
      )(_.bytesPerSecond)
      .optionallyWith(taskQueueing.map(value => value.unwrap))(_.taskQueueing)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(transferMode.map(value => value.unwrap))(_.transferMode)
      .optionallyWith(securityDescriptorCopyFlags.map(value => value.unwrap))(
        _.securityDescriptorCopyFlags
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Options.ReadOnly =
    zio.aws.datasync.model.Options.wrap(buildAwsValue())
}
object Options {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datasync.model.Options] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Options =
      zio.aws.datasync.model.Options(
        verifyMode.map(value => value),
        overwriteMode.map(value => value),
        atime.map(value => value),
        mtime.map(value => value),
        uid.map(value => value),
        gid.map(value => value),
        preserveDeletedFiles.map(value => value),
        preserveDevices.map(value => value),
        posixPermissions.map(value => value),
        bytesPerSecond.map(value => value),
        taskQueueing.map(value => value),
        logLevel.map(value => value),
        transferMode.map(value => value),
        securityDescriptorCopyFlags.map(value => value)
      )
    def verifyMode: Option[zio.aws.datasync.model.VerifyMode]
    def overwriteMode: Option[zio.aws.datasync.model.OverwriteMode]
    def atime: Option[zio.aws.datasync.model.Atime]
    def mtime: Option[zio.aws.datasync.model.Mtime]
    def uid: Option[zio.aws.datasync.model.Uid]
    def gid: Option[zio.aws.datasync.model.Gid]
    def preserveDeletedFiles
        : Option[zio.aws.datasync.model.PreserveDeletedFiles]
    def preserveDevices: Option[zio.aws.datasync.model.PreserveDevices]
    def posixPermissions: Option[zio.aws.datasync.model.PosixPermissions]
    def bytesPerSecond: Option[BytesPerSecond]
    def taskQueueing: Option[zio.aws.datasync.model.TaskQueueing]
    def logLevel: Option[zio.aws.datasync.model.LogLevel]
    def transferMode: Option[zio.aws.datasync.model.TransferMode]
    def securityDescriptorCopyFlags
        : Option[zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags]
    def getVerifyMode: ZIO[Any, AwsError, zio.aws.datasync.model.VerifyMode] =
      AwsError.unwrapOptionField("verifyMode", verifyMode)
    def getOverwriteMode
        : ZIO[Any, AwsError, zio.aws.datasync.model.OverwriteMode] =
      AwsError.unwrapOptionField("overwriteMode", overwriteMode)
    def getAtime: ZIO[Any, AwsError, zio.aws.datasync.model.Atime] =
      AwsError.unwrapOptionField("atime", atime)
    def getMtime: ZIO[Any, AwsError, zio.aws.datasync.model.Mtime] =
      AwsError.unwrapOptionField("mtime", mtime)
    def getUid: ZIO[Any, AwsError, zio.aws.datasync.model.Uid] =
      AwsError.unwrapOptionField("uid", uid)
    def getGid: ZIO[Any, AwsError, zio.aws.datasync.model.Gid] =
      AwsError.unwrapOptionField("gid", gid)
    def getPreserveDeletedFiles
        : ZIO[Any, AwsError, zio.aws.datasync.model.PreserveDeletedFiles] =
      AwsError.unwrapOptionField("preserveDeletedFiles", preserveDeletedFiles)
    def getPreserveDevices
        : ZIO[Any, AwsError, zio.aws.datasync.model.PreserveDevices] =
      AwsError.unwrapOptionField("preserveDevices", preserveDevices)
    def getPosixPermissions
        : ZIO[Any, AwsError, zio.aws.datasync.model.PosixPermissions] =
      AwsError.unwrapOptionField("posixPermissions", posixPermissions)
    def getBytesPerSecond: ZIO[Any, AwsError, BytesPerSecond] =
      AwsError.unwrapOptionField("bytesPerSecond", bytesPerSecond)
    def getTaskQueueing
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskQueueing] =
      AwsError.unwrapOptionField("taskQueueing", taskQueueing)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.datasync.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getTransferMode
        : ZIO[Any, AwsError, zio.aws.datasync.model.TransferMode] =
      AwsError.unwrapOptionField("transferMode", transferMode)
    def getSecurityDescriptorCopyFlags: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags
    ] = AwsError.unwrapOptionField(
      "securityDescriptorCopyFlags",
      securityDescriptorCopyFlags
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Options
  ) extends zio.aws.datasync.model.Options.ReadOnly {
    override val verifyMode: Option[zio.aws.datasync.model.VerifyMode] = scala
      .Option(impl.verifyMode())
      .map(value => zio.aws.datasync.model.VerifyMode.wrap(value))
    override val overwriteMode: Option[zio.aws.datasync.model.OverwriteMode] =
      scala
        .Option(impl.overwriteMode())
        .map(value => zio.aws.datasync.model.OverwriteMode.wrap(value))
    override val atime: Option[zio.aws.datasync.model.Atime] = scala
      .Option(impl.atime())
      .map(value => zio.aws.datasync.model.Atime.wrap(value))
    override val mtime: Option[zio.aws.datasync.model.Mtime] = scala
      .Option(impl.mtime())
      .map(value => zio.aws.datasync.model.Mtime.wrap(value))
    override val uid: Option[zio.aws.datasync.model.Uid] = scala
      .Option(impl.uid())
      .map(value => zio.aws.datasync.model.Uid.wrap(value))
    override val gid: Option[zio.aws.datasync.model.Gid] = scala
      .Option(impl.gid())
      .map(value => zio.aws.datasync.model.Gid.wrap(value))
    override val preserveDeletedFiles
        : Option[zio.aws.datasync.model.PreserveDeletedFiles] = scala
      .Option(impl.preserveDeletedFiles())
      .map(value => zio.aws.datasync.model.PreserveDeletedFiles.wrap(value))
    override val preserveDevices
        : Option[zio.aws.datasync.model.PreserveDevices] = scala
      .Option(impl.preserveDevices())
      .map(value => zio.aws.datasync.model.PreserveDevices.wrap(value))
    override val posixPermissions
        : Option[zio.aws.datasync.model.PosixPermissions] = scala
      .Option(impl.posixPermissions())
      .map(value => zio.aws.datasync.model.PosixPermissions.wrap(value))
    override val bytesPerSecond: Option[BytesPerSecond] = scala
      .Option(impl.bytesPerSecond())
      .map(value => zio.aws.datasync.model.primitives.BytesPerSecond(value))
    override val taskQueueing: Option[zio.aws.datasync.model.TaskQueueing] =
      scala
        .Option(impl.taskQueueing())
        .map(value => zio.aws.datasync.model.TaskQueueing.wrap(value))
    override val logLevel: Option[zio.aws.datasync.model.LogLevel] = scala
      .Option(impl.logLevel())
      .map(value => zio.aws.datasync.model.LogLevel.wrap(value))
    override val transferMode: Option[zio.aws.datasync.model.TransferMode] =
      scala
        .Option(impl.transferMode())
        .map(value => zio.aws.datasync.model.TransferMode.wrap(value))
    override val securityDescriptorCopyFlags
        : Option[zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags] = scala
      .Option(impl.securityDescriptorCopyFlags())
      .map(value =>
        zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Options
  ): zio.aws.datasync.model.Options.ReadOnly = new Wrapper(impl)
}
