package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  SmbUser,
  Time,
  LocationArn,
  SmbDomain,
  LocationUri
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeLocationFsxWindowsResponse(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None,
    securityGroupArns: Option[Iterable[Ec2SecurityGroupArn]] = None,
    creationTime: Option[Time] = None,
    user: Option[SmbUser] = None,
    domain: Option[SmbDomain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse = {
    import DescribeLocationFsxWindowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxWindowsResponse
      .wrap(buildAwsValue())
}
object DescribeLocationFsxWindowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxWindowsResponse =
      zio.aws.datasync.model.DescribeLocationFsxWindowsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        securityGroupArns.map(value => value),
        creationTime.map(value => value),
        user.map(value => value),
        domain.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def securityGroupArns: Option[List[Ec2SecurityGroupArn]]
    def creationTime: Option[Time]
    def user: Option[SmbUser]
    def domain: Option[SmbDomain]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
  ) extends zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val securityGroupArns: Option[List[Ec2SecurityGroupArn]] = scala
      .Option(impl.securityGroupArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
        }.toList
      )
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val user: Option[SmbUser] = scala
      .Option(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Option[SmbDomain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
  ): zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly =
    new Wrapper(impl)
}
