package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLocationHdfsResponse(
    locationArn: Option[LocationArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse = {
    import CreateLocationHdfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationHdfsResponse.wrap(buildAwsValue())
}
object CreateLocationHdfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationHdfsResponse =
      zio.aws.datasync.model
        .CreateLocationHdfsResponse(locationArn.map(value => value))
    def locationArn: Option[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse
  ) extends zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse
  ): zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
