package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{LocationUri, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocationListEntry(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.LocationListEntry = {
    import LocationListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.LocationListEntry
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.LocationListEntry.ReadOnly =
    zio.aws.datasync.model.LocationListEntry.wrap(buildAwsValue())
}
object LocationListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.LocationListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.LocationListEntry =
      zio.aws.datasync.model.LocationListEntry(
        locationArn.map(value => value),
        locationUri.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.LocationListEntry
  ) extends zio.aws.datasync.model.LocationListEntry.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.LocationListEntry
  ): zio.aws.datasync.model.LocationListEntry.ReadOnly = new Wrapper(impl)
}
