package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait HdfsRpcProtection {
  def unwrap: software.amazon.awssdk.services.datasync.model.HdfsRpcProtection
}
object HdfsRpcProtection {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.HdfsRpcProtection
  ): zio.aws.datasync.model.HdfsRpcProtection = value match {
    case software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.AUTHENTICATION =>
      val r = AUTHENTICATION
      r
    case software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.INTEGRITY =>
      val r = INTEGRITY
      r
    case software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.PRIVACY =>
      val r = PRIVACY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.HdfsRpcProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsRpcProtection =
      software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.datasync.model.HdfsRpcProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsRpcProtection =
      software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.DISABLED
  }
  case object AUTHENTICATION extends zio.aws.datasync.model.HdfsRpcProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsRpcProtection =
      software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.AUTHENTICATION
  }
  case object INTEGRITY extends zio.aws.datasync.model.HdfsRpcProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsRpcProtection =
      software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.INTEGRITY
  }
  case object PRIVACY extends zio.aws.datasync.model.HdfsRpcProtection {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsRpcProtection =
      software.amazon.awssdk.services.datasync.model.HdfsRpcProtection.PRIVACY
  }
}
