package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLocationFsxWindowsResponse(
    locationArn: Option[LocationArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse = {
    import CreateLocationFsxWindowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxWindowsResponse
      .wrap(buildAwsValue())
}
object CreateLocationFsxWindowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxWindowsResponse =
      zio.aws.datasync.model
        .CreateLocationFsxWindowsResponse(locationArn.map(value => value))
    def locationArn: Option[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse
  ) extends zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse
  ): zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly =
    new Wrapper(impl)
}
