package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLocationHdfsRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest = {
    import DescribeLocationHdfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationHdfsRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationHdfsRequest.wrap(buildAwsValue())
}
object DescribeLocationHdfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationHdfsRequest =
      zio.aws.datasync.model.DescribeLocationHdfsRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest
  ) extends zio.aws.datasync.model.DescribeLocationHdfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest
  ): zio.aws.datasync.model.DescribeLocationHdfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
