package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  SmbUser,
  SmbPassword,
  FsxFilesystemArn,
  FsxWindowsSubdirectory,
  SmbDomain
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLocationFsxWindowsRequest(
    subdirectory: Option[FsxWindowsSubdirectory] = None,
    fsxFilesystemArn: FsxFilesystemArn,
    securityGroupArns: Iterable[Ec2SecurityGroupArn],
    tags: Option[Iterable[zio.aws.datasync.model.TagListEntry]] = None,
    user: SmbUser,
    domain: Option[SmbDomain] = None,
    password: SmbPassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest = {
    import CreateLocationFsxWindowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest
      .builder()
      .optionallyWith(
        subdirectory.map(value =>
          FsxWindowsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .fsxFilesystemArn(
        FsxFilesystemArn.unwrap(fsxFilesystemArn): java.lang.String
      )
      .securityGroupArns(securityGroupArns.map { item =>
        Ec2SecurityGroupArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .user(SmbUser.unwrap(user): java.lang.String)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .password(SmbPassword.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxWindowsRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxWindowsRequest.wrap(buildAwsValue())
}
object CreateLocationFsxWindowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxWindowsRequest =
      zio.aws.datasync.model.CreateLocationFsxWindowsRequest(
        subdirectory.map(value => value),
        fsxFilesystemArn,
        securityGroupArns,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        user,
        domain.map(value => value),
        password
      )
    def subdirectory: Option[FsxWindowsSubdirectory]
    def fsxFilesystemArn: FsxFilesystemArn
    def securityGroupArns: List[Ec2SecurityGroupArn]
    def tags: Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def user: SmbUser
    def domain: Option[SmbDomain]
    def password: SmbPassword
    def getSubdirectory: ZIO[Any, AwsError, FsxWindowsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getFsxFilesystemArn: ZIO[Any, Nothing, FsxFilesystemArn] =
      ZIO.succeed(fsxFilesystemArn)
    def getSecurityGroupArns: ZIO[Any, Nothing, List[Ec2SecurityGroupArn]] =
      ZIO.succeed(securityGroupArns)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getUser: ZIO[Any, Nothing, SmbUser] = ZIO.succeed(user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getPassword: ZIO[Any, Nothing, SmbPassword] = ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest
  ) extends zio.aws.datasync.model.CreateLocationFsxWindowsRequest.ReadOnly {
    override val subdirectory: Option[FsxWindowsSubdirectory] = scala
      .Option(impl.subdirectory())
      .map(value =>
        zio.aws.datasync.model.primitives.FsxWindowsSubdirectory(value)
      )
    override val fsxFilesystemArn: FsxFilesystemArn =
      zio.aws.datasync.model.primitives
        .FsxFilesystemArn(impl.fsxFilesystemArn())
    override val securityGroupArns: List[Ec2SecurityGroupArn] = impl
      .securityGroupArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
      }
      .toList
    override val tags
        : Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TagListEntry.wrap(item)
        }.toList
      )
    override val user: SmbUser =
      zio.aws.datasync.model.primitives.SmbUser(impl.user())
    override val domain: Option[SmbDomain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val password: SmbPassword =
      zio.aws.datasync.model.primitives.SmbPassword(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest
  ): zio.aws.datasync.model.CreateLocationFsxWindowsRequest.ReadOnly =
    new Wrapper(impl)
}
