package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{Time, LocationUri, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeLocationNfsResponse(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None,
    onPremConfig: Option[zio.aws.datasync.model.OnPremConfig] = None,
    mountOptions: Option[zio.aws.datasync.model.NfsMountOptions] = None,
    creationTime: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse = {
    import DescribeLocationNfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(onPremConfig.map(value => value.buildAwsValue()))(
        _.onPremConfig
      )
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationNfsResponse.wrap(buildAwsValue())
}
object DescribeLocationNfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationNfsResponse =
      zio.aws.datasync.model.DescribeLocationNfsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        onPremConfig.map(value => value.asEditable),
        mountOptions.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def onPremConfig: Option[zio.aws.datasync.model.OnPremConfig.ReadOnly]
    def mountOptions: Option[zio.aws.datasync.model.NfsMountOptions.ReadOnly]
    def creationTime: Option[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getOnPremConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.OnPremConfig.ReadOnly] =
      AwsError.unwrapOptionField("onPremConfig", onPremConfig)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
  ) extends zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val onPremConfig
        : Option[zio.aws.datasync.model.OnPremConfig.ReadOnly] = scala
      .Option(impl.onPremConfig())
      .map(value => zio.aws.datasync.model.OnPremConfig.wrap(value))
    override val mountOptions
        : Option[zio.aws.datasync.model.NfsMountOptions.ReadOnly] = scala
      .Option(impl.mountOptions())
      .map(value => zio.aws.datasync.model.NfsMountOptions.wrap(value))
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
  ): zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
