package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait Gid {
  def unwrap: software.amazon.awssdk.services.datasync.model.Gid
}
object Gid {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.Gid
  ): zio.aws.datasync.model.Gid = value match {
    case software.amazon.awssdk.services.datasync.model.Gid.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.Gid.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.Gid.INT_VALUE =>
      val r = INT_VALUE
      r
    case software.amazon.awssdk.services.datasync.model.Gid.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.datasync.model.Gid.BOTH =>
      val r = BOTH
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.Gid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Gid =
      software.amazon.awssdk.services.datasync.model.Gid.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.Gid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Gid =
      software.amazon.awssdk.services.datasync.model.Gid.NONE
  }
  case object INT_VALUE extends zio.aws.datasync.model.Gid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Gid =
      software.amazon.awssdk.services.datasync.model.Gid.INT_VALUE
  }
  case object NAME extends zio.aws.datasync.model.Gid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Gid =
      software.amazon.awssdk.services.datasync.model.Gid.NAME
  }
  case object BOTH extends zio.aws.datasync.model.Gid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Gid =
      software.amazon.awssdk.services.datasync.model.Gid.BOTH
  }
}
