package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPipelinesRequest(
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest = {
    import ListPipelinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ListPipelinesRequest.ReadOnly =
    zio.aws.datapipeline.model.ListPipelinesRequest.wrap(buildAwsValue())
}
object ListPipelinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ListPipelinesRequest =
      zio.aws.datapipeline.model
        .ListPipelinesRequest(marker.map(value => value))
    def marker: Optional[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest
  ) extends zio.aws.datapipeline.model.ListPipelinesRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest
  ): zio.aws.datapipeline.model.ListPipelinesRequest.ReadOnly = new Wrapper(
    impl
  )
}
