package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribePipelinesResponse(
    pipelineDescriptionList: Iterable[
      zio.aws.datapipeline.model.PipelineDescription
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse = {
    import DescribePipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse
      .builder()
      .pipelineDescriptionList(pipelineDescriptionList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.DescribePipelinesResponse.ReadOnly =
    zio.aws.datapipeline.model.DescribePipelinesResponse.wrap(buildAwsValue())
}
object DescribePipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.DescribePipelinesResponse =
      zio.aws.datapipeline.model
        .DescribePipelinesResponse(pipelineDescriptionList.map { item =>
          item.asEditable
        })
    def pipelineDescriptionList
        : List[zio.aws.datapipeline.model.PipelineDescription.ReadOnly]
    def getPipelineDescriptionList: ZIO[Any, Nothing, List[
      zio.aws.datapipeline.model.PipelineDescription.ReadOnly
    ]] = ZIO.succeed(pipelineDescriptionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse
  ) extends zio.aws.datapipeline.model.DescribePipelinesResponse.ReadOnly {
    override val pipelineDescriptionList
        : List[zio.aws.datapipeline.model.PipelineDescription.ReadOnly] = impl
      .pipelineDescriptionList()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.PipelineDescription.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse
  ): zio.aws.datapipeline.model.DescribePipelinesResponse.ReadOnly =
    new Wrapper(impl)
}
