package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.{CancelActive, Id}
import scala.jdk.CollectionConverters.*
final case class DeactivatePipelineRequest(
    pipelineId: Id,
    cancelActive: Optional[CancelActive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest = {
    import DeactivatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(
        cancelActive.map(value => CancelActive.unwrap(value): java.lang.Boolean)
      )(_.cancelActive)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.DeactivatePipelineRequest.ReadOnly =
    zio.aws.datapipeline.model.DeactivatePipelineRequest.wrap(buildAwsValue())
}
object DeactivatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.DeactivatePipelineRequest =
      zio.aws.datapipeline.model
        .DeactivatePipelineRequest(pipelineId, cancelActive.map(value => value))
    def pipelineId: Id
    def cancelActive: Optional[CancelActive]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getCancelActive: ZIO[Any, AwsError, CancelActive] =
      AwsError.unwrapOptionField("cancelActive", cancelActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest
  ) extends zio.aws.datapipeline.model.DeactivatePipelineRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val cancelActive: Optional[CancelActive] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelActive())
      .map(value => zio.aws.datapipeline.model.primitives.CancelActive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest
  ): zio.aws.datapipeline.model.DeactivatePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
