package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.{ValidationMessage, Id}
import scala.jdk.CollectionConverters.*
final case class ValidationError(
    id: Optional[Id] = Optional.Absent,
    errors: Optional[Iterable[ValidationMessage]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ValidationError = {
    import ValidationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ValidationError
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            ValidationMessage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ValidationError.ReadOnly =
    zio.aws.datapipeline.model.ValidationError.wrap(buildAwsValue())
}
object ValidationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ValidationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ValidationError =
      zio.aws.datapipeline.model
        .ValidationError(id.map(value => value), errors.map(value => value))
    def id: Optional[Id]
    def errors: Optional[List[ValidationMessage]]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getErrors: ZIO[Any, AwsError, List[ValidationMessage]] =
      AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidationError
  ) extends zio.aws.datapipeline.model.ValidationError.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val errors: Optional[List[ValidationMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.primitives.ValidationMessage(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidationError
  ): zio.aws.datapipeline.model.ValidationError.ReadOnly = new Wrapper(impl)
}
