package zio.aws.datapipeline.model
import zio.aws.datapipeline.model.primitives.{Timestamp, Id}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ActivatePipelineRequest(
    pipelineId: Id,
    parameterValues: Optional[
      Iterable[zio.aws.datapipeline.model.ParameterValue]
    ] = Optional.Absent,
    startTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest = {
    import ActivatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(
        parameterValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterValues)
      .optionallyWith(
        startTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ActivatePipelineRequest.ReadOnly =
    zio.aws.datapipeline.model.ActivatePipelineRequest.wrap(buildAwsValue())
}
object ActivatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ActivatePipelineRequest =
      zio.aws.datapipeline.model.ActivatePipelineRequest(
        pipelineId,
        parameterValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTimestamp.map(value => value)
      )
    def pipelineId: Id
    def parameterValues
        : Optional[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]]
    def startTimestamp: Optional[Timestamp]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getParameterValues: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterValues", parameterValues)
    def getStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
  ) extends zio.aws.datapipeline.model.ActivatePipelineRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val parameterValues
        : Optional[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ParameterValue.wrap(item)
          }.toList
        )
    override val startTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimestamp())
      .map(value => zio.aws.datapipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
  ): zio.aws.datapipeline.model.ActivatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
