package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.LongString
import scala.jdk.CollectionConverters.*
final case class EvaluateExpressionResponse(evaluatedExpression: LongString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse = {
    import EvaluateExpressionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse
      .builder()
      .evaluatedExpression(
        LongString.unwrap(evaluatedExpression): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly =
    zio.aws.datapipeline.model.EvaluateExpressionResponse.wrap(buildAwsValue())
}
object EvaluateExpressionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.EvaluateExpressionResponse =
      zio.aws.datapipeline.model.EvaluateExpressionResponse(evaluatedExpression)
    def evaluatedExpression: LongString
    def getEvaluatedExpression: ZIO[Any, Nothing, LongString] =
      ZIO.succeed(evaluatedExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse
  ) extends zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly {
    override val evaluatedExpression: LongString =
      zio.aws.datapipeline.model.primitives
        .LongString(impl.evaluatedExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse
  ): zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly =
    new Wrapper(impl)
}
