package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class GetPipelineDefinitionRequest(
    pipelineId: Id,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest = {
    import GetPipelineDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.GetPipelineDefinitionRequest.ReadOnly =
    zio.aws.datapipeline.model.GetPipelineDefinitionRequest
      .wrap(buildAwsValue())
}
object GetPipelineDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.GetPipelineDefinitionRequest =
      zio.aws.datapipeline.model
        .GetPipelineDefinitionRequest(pipelineId, version.map(value => value))
    def pipelineId: Id
    def version: Optional[String]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest
  ) extends zio.aws.datapipeline.model.GetPipelineDefinitionRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest
  ): zio.aws.datapipeline.model.GetPipelineDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
