package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PollForTaskResponse(
    taskObject: Optional[zio.aws.datapipeline.model.TaskObject] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse = {
    import PollForTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
      .builder()
      .optionallyWith(taskObject.map(value => value.buildAwsValue()))(
        _.taskObject
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly =
    zio.aws.datapipeline.model.PollForTaskResponse.wrap(buildAwsValue())
}
object PollForTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PollForTaskResponse =
      zio.aws.datapipeline.model
        .PollForTaskResponse(taskObject.map(value => value.asEditable))
    def taskObject: Optional[zio.aws.datapipeline.model.TaskObject.ReadOnly]
    def getTaskObject
        : ZIO[Any, AwsError, zio.aws.datapipeline.model.TaskObject.ReadOnly] =
      AwsError.unwrapOptionField("taskObject", taskObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
  ) extends zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly {
    override val taskObject
        : Optional[zio.aws.datapipeline.model.TaskObject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskObject())
        .map(value => zio.aws.datapipeline.model.TaskObject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
  ): zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly = new Wrapper(impl)
}
