package zio.aws.datapipeline
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.datapipeline.model.primitives.{ValidationMessage, Id}
import zio.aws.datapipeline.model.primitives.TagKey.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AttributeNameString extends Subtype[String]
    type AttributeNameString =
      zio.aws.datapipeline.model.primitives.AttributeNameString.Type
    object AttributeValueString extends Subtype[String]
    type AttributeValueString =
      zio.aws.datapipeline.model.primitives.AttributeValueString.Type
    object CancelActive extends Subtype[Boolean]
    type CancelActive = zio.aws.datapipeline.model.primitives.CancelActive.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.datapipeline.model.primitives.ErrorMessage.Type
    object FieldNameString extends Subtype[String]
    type FieldNameString =
      zio.aws.datapipeline.model.primitives.FieldNameString.Type
    object FieldStringValue extends Subtype[String]
    type FieldStringValue =
      zio.aws.datapipeline.model.primitives.FieldStringValue.Type
    object Id extends Subtype[String]
    type Id = zio.aws.datapipeline.model.primitives.Id.Type
    object LongString extends Subtype[String]
    type LongString = zio.aws.datapipeline.model.primitives.LongString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.datapipeline.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.datapipeline.model.primitives.TagValue.Type
    object TaskId extends Subtype[String]
    type TaskId = zio.aws.datapipeline.model.primitives.TaskId.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.datapipeline.model.primitives.Timestamp.Type
    object ValidationMessage extends Subtype[String]
    type ValidationMessage =
      zio.aws.datapipeline.model.primitives.ValidationMessage.Type
  }
  type FieldList = List[zio.aws.datapipeline.model.Field]
  type IdList = List[Id]
  type ParameterAttributeList =
    List[zio.aws.datapipeline.model.ParameterAttribute]
  type ParameterObjectList = List[zio.aws.datapipeline.model.ParameterObject]
  type ParameterValueList = List[zio.aws.datapipeline.model.ParameterValue]
  type PipelineDescriptionList =
    List[zio.aws.datapipeline.model.PipelineDescription]
  type PipelineList = List[zio.aws.datapipeline.model.PipelineIdName]
  type PipelineObjectList = List[zio.aws.datapipeline.model.PipelineObject]
  type PipelineObjectMap = Map[Id, zio.aws.datapipeline.model.PipelineObject]
  type SelectorList = List[zio.aws.datapipeline.model.Selector]
  type StringList = List[String]
  type TagList = List[zio.aws.datapipeline.model.Tag]
  type ValidationErrors = List[zio.aws.datapipeline.model.ValidationError]
  type ValidationMessages = List[ValidationMessage]
  type ValidationWarnings = List[zio.aws.datapipeline.model.ValidationWarning]
}
