package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class PipelineObject(
    id: Id,
    name: Id,
    fields: Iterable[zio.aws.datapipeline.model.Field]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PipelineObject = {
    import PipelineObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PipelineObject
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .name(Id.unwrap(name): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.PipelineObject.ReadOnly =
    zio.aws.datapipeline.model.PipelineObject.wrap(buildAwsValue())
}
object PipelineObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PipelineObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PipelineObject =
      zio.aws.datapipeline.model.PipelineObject(
        id,
        name,
        fields.map { item =>
          item.asEditable
        }
      )
    def id: Id
    def name: Id
    def fields: List[zio.aws.datapipeline.model.Field.ReadOnly]
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Id] = ZIO.succeed(name)
    def getFields
        : ZIO[Any, Nothing, List[zio.aws.datapipeline.model.Field.ReadOnly]] =
      ZIO.succeed(fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PipelineObject
  ) extends zio.aws.datapipeline.model.PipelineObject.ReadOnly {
    override val id: Id = zio.aws.datapipeline.model.primitives.Id(impl.id())
    override val name: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.name())
    override val fields: List[zio.aws.datapipeline.model.Field.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.Field.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PipelineObject
  ): zio.aws.datapipeline.model.PipelineObject.ReadOnly = new Wrapper(impl)
}
