package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class CreatePipelineResponse(pipelineId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse = {
    import CreatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly =
    zio.aws.datapipeline.model.CreatePipelineResponse.wrap(buildAwsValue())
}
object CreatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.CreatePipelineResponse =
      zio.aws.datapipeline.model.CreatePipelineResponse(pipelineId)
    def pipelineId: Id
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse
  ) extends zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse
  ): zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
