package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.{Id, TaskId}
import scala.jdk.CollectionConverters.*
final case class TaskObject(
    taskId: Option[TaskId] = None,
    pipelineId: Option[Id] = None,
    attemptId: Option[Id] = None,
    objects: Option[Map[Id, zio.aws.datapipeline.model.PipelineObject]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.TaskObject = {
    import TaskObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.TaskObject
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        pipelineId.map(value => Id.unwrap(value): java.lang.String)
      )(_.pipelineId)
      .optionallyWith(
        attemptId.map(value => Id.unwrap(value): java.lang.String)
      )(_.attemptId)
      .optionallyWith(
        objects.map(value =>
          value
            .map({ case (key, value) =>
              (Id.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.objects)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.TaskObject.ReadOnly =
    zio.aws.datapipeline.model.TaskObject.wrap(buildAwsValue())
}
object TaskObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.TaskObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.TaskObject =
      zio.aws.datapipeline.model.TaskObject(
        taskId.map(value => value),
        pipelineId.map(value => value),
        attemptId.map(value => value),
        objects.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def taskId: Option[TaskId]
    def pipelineId: Option[Id]
    def attemptId: Option[Id]
    def objects
        : Option[Map[Id, zio.aws.datapipeline.model.PipelineObject.ReadOnly]]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getPipelineId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pipelineId", pipelineId)
    def getAttemptId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("attemptId", attemptId)
    def getObjects: ZIO[Any, AwsError, Map[
      Id,
      zio.aws.datapipeline.model.PipelineObject.ReadOnly
    ]] = AwsError.unwrapOptionField("objects", objects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.TaskObject
  ) extends zio.aws.datapipeline.model.TaskObject.ReadOnly {
    override val taskId: Option[TaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.datapipeline.model.primitives.TaskId(value))
    override val pipelineId: Option[Id] = scala
      .Option(impl.pipelineId())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val attemptId: Option[Id] = scala
      .Option(impl.attemptId())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val objects
        : Option[Map[Id, zio.aws.datapipeline.model.PipelineObject.ReadOnly]] =
      scala
        .Option(impl.objects())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.datapipeline.model.primitives.Id(
                key
              ) -> zio.aws.datapipeline.model.PipelineObject.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.TaskObject
  ): zio.aws.datapipeline.model.TaskObject.ReadOnly = new Wrapper(impl)
}
