package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.TaskId
import scala.jdk.CollectionConverters.*
final case class ReportTaskProgressRequest(
    taskId: TaskId,
    fields: Option[Iterable[zio.aws.datapipeline.model.Field]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest = {
    import ReportTaskProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fields)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.ReportTaskProgressRequest.ReadOnly =
    zio.aws.datapipeline.model.ReportTaskProgressRequest.wrap(buildAwsValue())
}
object ReportTaskProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ReportTaskProgressRequest =
      zio.aws.datapipeline.model.ReportTaskProgressRequest(
        taskId,
        fields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskId: TaskId
    def fields: Option[List[zio.aws.datapipeline.model.Field.ReadOnly]]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getFields
        : ZIO[Any, AwsError, List[zio.aws.datapipeline.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest
  ) extends zio.aws.datapipeline.model.ReportTaskProgressRequest.ReadOnly {
    override val taskId: TaskId =
      zio.aws.datapipeline.model.primitives.TaskId(impl.taskId())
    override val fields
        : Option[List[zio.aws.datapipeline.model.Field.ReadOnly]] = scala
      .Option(impl.fields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datapipeline.model.Field.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest
  ): zio.aws.datapipeline.model.ReportTaskProgressRequest.ReadOnly =
    new Wrapper(impl)
}
