package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class DescribeObjectsRequest(
    pipelineId: Id,
    objectIds: Iterable[Id],
    evaluateExpressions: Option[Boolean] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest = {
    import DescribeObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .objectIds(objectIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        evaluateExpressions.map(value => value: java.lang.Boolean)
      )(_.evaluateExpressions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.DescribeObjectsRequest.ReadOnly =
    zio.aws.datapipeline.model.DescribeObjectsRequest.wrap(buildAwsValue())
}
object DescribeObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.DescribeObjectsRequest =
      zio.aws.datapipeline.model.DescribeObjectsRequest(
        pipelineId,
        objectIds,
        evaluateExpressions.map(value => value),
        marker.map(value => value)
      )
    def pipelineId: Id
    def objectIds: List[Id]
    def evaluateExpressions: Option[Boolean]
    def marker: Option[String]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getObjectIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(objectIds)
    def getEvaluateExpressions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("evaluateExpressions", evaluateExpressions)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest
  ) extends zio.aws.datapipeline.model.DescribeObjectsRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val objectIds: List[Id] = impl
      .objectIds()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.primitives.Id(item)
      }
      .toList
    override val evaluateExpressions: Option[Boolean] =
      scala.Option(impl.evaluateExpressions()).map(value => value: Boolean)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest
  ): zio.aws.datapipeline.model.DescribeObjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
