package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeObjectsResponse(
    pipelineObjects: Iterable[zio.aws.datapipeline.model.PipelineObject],
    marker: Option[String] = None,
    hasMoreResults: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse = {
    import DescribeObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse
      .builder()
      .pipelineObjects(pipelineObjects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(hasMoreResults.map(value => value: java.lang.Boolean))(
        _.hasMoreResults
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly =
    zio.aws.datapipeline.model.DescribeObjectsResponse.wrap(buildAwsValue())
}
object DescribeObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.DescribeObjectsResponse =
      zio.aws.datapipeline.model.DescribeObjectsResponse(
        pipelineObjects.map { item =>
          item.asEditable
        },
        marker.map(value => value),
        hasMoreResults.map(value => value)
      )
    def pipelineObjects
        : List[zio.aws.datapipeline.model.PipelineObject.ReadOnly]
    def marker: Option[String]
    def hasMoreResults: Option[Boolean]
    def getPipelineObjects: ZIO[Any, Nothing, List[
      zio.aws.datapipeline.model.PipelineObject.ReadOnly
    ]] = ZIO.succeed(pipelineObjects)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getHasMoreResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasMoreResults", hasMoreResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse
  ) extends zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly {
    override val pipelineObjects
        : List[zio.aws.datapipeline.model.PipelineObject.ReadOnly] = impl
      .pipelineObjects()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.PipelineObject.wrap(item)
      }
      .toList
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val hasMoreResults: Option[Boolean] =
      scala.Option(impl.hasMoreResults()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse
  ): zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
