package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceIdentity(
    document: Option[String] = None,
    signature: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.InstanceIdentity = {
    import InstanceIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.InstanceIdentity
      .builder()
      .optionallyWith(document.map(value => value: java.lang.String))(
        _.document
      )
      .optionallyWith(signature.map(value => value: java.lang.String))(
        _.signature
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.InstanceIdentity.ReadOnly =
    zio.aws.datapipeline.model.InstanceIdentity.wrap(buildAwsValue())
}
object InstanceIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.InstanceIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.InstanceIdentity =
      zio.aws.datapipeline.model.InstanceIdentity(
        document.map(value => value),
        signature.map(value => value)
      )
    def document: Option[String]
    def signature: Option[String]
    def getDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("document", document)
    def getSignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signature", signature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.InstanceIdentity
  ) extends zio.aws.datapipeline.model.InstanceIdentity.ReadOnly {
    override val document: Option[String] =
      scala.Option(impl.document()).map(value => value: String)
    override val signature: Option[String] =
      scala.Option(impl.signature()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.InstanceIdentity
  ): zio.aws.datapipeline.model.InstanceIdentity.ReadOnly = new Wrapper(impl)
}
