package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class SetStatusRequest(
    pipelineId: Id,
    objectIds: Iterable[Id],
    status: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.SetStatusRequest = {
    import SetStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.SetStatusRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .objectIds(objectIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .status(status: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.SetStatusRequest.ReadOnly =
    zio.aws.datapipeline.model.SetStatusRequest.wrap(buildAwsValue())
}
object SetStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.SetStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.SetStatusRequest =
      zio.aws.datapipeline.model.SetStatusRequest(pipelineId, objectIds, status)
    def pipelineId: Id
    def objectIds: List[Id]
    def status: String
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getObjectIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(objectIds)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.SetStatusRequest
  ) extends zio.aws.datapipeline.model.SetStatusRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val objectIds: List[Id] = impl
      .objectIds()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.primitives.Id(item)
      }
      .toList
    override val status: String = impl.status(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.SetStatusRequest
  ): zio.aws.datapipeline.model.SetStatusRequest.ReadOnly = new Wrapper(impl)
}
