package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class RemoveTagsRequest(pipelineId: Id, tagKeys: Iterable[String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest = {
    import RemoveTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.RemoveTagsRequest.ReadOnly =
    zio.aws.datapipeline.model.RemoveTagsRequest.wrap(buildAwsValue())
}
object RemoveTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.RemoveTagsRequest =
      zio.aws.datapipeline.model.RemoveTagsRequest(pipelineId, tagKeys)
    def pipelineId: Id
    def tagKeys: List[String]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest
  ) extends zio.aws.datapipeline.model.RemoveTagsRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest
  ): zio.aws.datapipeline.model.RemoveTagsRequest.ReadOnly = new Wrapper(impl)
}
