package zio.aws.datapipeline.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class QueryObjectsRequest(
    pipelineId: Id,
    query: Option[zio.aws.datapipeline.model.Query] = None,
    sphere: String,
    marker: Option[String] = None,
    limit: Option[Int] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest = {
    import QueryObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(query.map(value => value.buildAwsValue()))(_.query)
      .sphere(sphere: java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.QueryObjectsRequest.ReadOnly =
    zio.aws.datapipeline.model.QueryObjectsRequest.wrap(buildAwsValue())
}
object QueryObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.QueryObjectsRequest =
      zio.aws.datapipeline.model.QueryObjectsRequest(
        pipelineId,
        query.map(value => value.asEditable),
        sphere,
        marker.map(value => value),
        limit.map(value => value)
      )
    def pipelineId: Id
    def query: Option[zio.aws.datapipeline.model.Query.ReadOnly]
    def sphere: String
    def marker: Option[String]
    def limit: Option[Int]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getQuery
        : ZIO[Any, AwsError, zio.aws.datapipeline.model.Query.ReadOnly] =
      AwsError.unwrapOptionField("query", query)
    def getSphere: ZIO[Any, Nothing, String] = ZIO.succeed(sphere)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, Int] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest
  ) extends zio.aws.datapipeline.model.QueryObjectsRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val query: Option[zio.aws.datapipeline.model.Query.ReadOnly] =
      scala
        .Option(impl.query())
        .map(value => zio.aws.datapipeline.model.Query.wrap(value))
    override val sphere: String = impl.sphere(): String
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val limit: Option[Int] =
      scala.Option(impl.limit()).map(value => value: Int)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest
  ): zio.aws.datapipeline.model.QueryObjectsRequest.ReadOnly = new Wrapper(impl)
}
