package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class PipelineDescription(
    pipelineId: Id,
    name: Id,
    fields: Iterable[zio.aws.datapipeline.model.Field],
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.datapipeline.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PipelineDescription = {
    import PipelineDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PipelineDescription
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .name(Id.unwrap(name): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.PipelineDescription.ReadOnly =
    zio.aws.datapipeline.model.PipelineDescription.wrap(buildAwsValue())
}
object PipelineDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PipelineDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PipelineDescription =
      zio.aws.datapipeline.model.PipelineDescription(
        pipelineId,
        name,
        fields.map { item =>
          item.asEditable
        },
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineId: Id
    def name: Id
    def fields: List[zio.aws.datapipeline.model.Field.ReadOnly]
    def description: Option[String]
    def tags: Option[List[zio.aws.datapipeline.model.Tag.ReadOnly]]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getName: ZIO[Any, Nothing, Id] = ZIO.succeed(name)
    def getFields
        : ZIO[Any, Nothing, List[zio.aws.datapipeline.model.Field.ReadOnly]] =
      ZIO.succeed(fields)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.datapipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PipelineDescription
  ) extends zio.aws.datapipeline.model.PipelineDescription.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val name: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.name())
    override val fields: List[zio.aws.datapipeline.model.Field.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.Field.wrap(item)
      }
      .toList
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.datapipeline.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PipelineDescription
  ): zio.aws.datapipeline.model.PipelineDescription.ReadOnly = new Wrapper(impl)
}
