package zio.aws.datapipeline
import zio.aws.datapipeline.model.DescribePipelinesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.datapipeline.model.primitives.Id
import software.amazon.awssdk.services.datapipeline.paginators.{
  QueryObjectsPublisher,
  ListPipelinesPublisher,
  DescribeObjectsPublisher
}
import zio.aws.datapipeline.model.{
  PutPipelineDefinitionRequest,
  ReportTaskProgressRequest,
  DescribePipelinesRequest,
  ValidatePipelineDefinitionRequest,
  SetStatusRequest,
  ListPipelinesRequest,
  ActivatePipelineRequest,
  AddTagsRequest,
  EvaluateExpressionRequest,
  QueryObjectsRequest,
  DeletePipelineRequest,
  DescribeObjectsRequest,
  CreatePipelineRequest,
  ReportTaskRunnerHeartbeatRequest,
  DeactivatePipelineRequest,
  RemoveTagsRequest,
  PollForTaskRequest,
  SetTaskStatusRequest,
  GetPipelineDefinitionRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.datapipeline.model.{
  ReportTaskProgressResponse,
  QueryObjectsResponse,
  DeactivatePipelineResponse,
  PutPipelineDefinitionResponse,
  PipelineIdName,
  RemoveTagsResponse,
  ActivatePipelineResponse,
  DescribePipelinesResponse,
  PollForTaskResponse,
  ListPipelinesResponse,
  EvaluateExpressionResponse,
  CreatePipelineResponse,
  SetStatusResponse,
  PipelineObject,
  AddTagsResponse,
  GetPipelineDefinitionResponse,
  DescribeObjectsResponse,
  SetTaskStatusResponse,
  ReportTaskRunnerHeartbeatResponse,
  DeletePipelineResponse,
  ValidatePipelineDefinitionResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.datapipeline.{
  DataPipelineAsyncClientBuilder,
  DataPipelineAsyncClient
}
import scala.jdk.CollectionConverters.*
trait DataPipeline extends AspectSupport[DataPipeline] {
  val api: DataPipelineAsyncClient
  def setTaskStatus(
      request: SetTaskStatusRequest
  ): IO[AwsError, zio.aws.datapipeline.model.SetTaskStatusResponse.ReadOnly]
  def pollForTask(
      request: PollForTaskRequest
  ): IO[AwsError, zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly]
  def activatePipeline(
      request: ActivatePipelineRequest
  ): IO[AwsError, zio.aws.datapipeline.model.ActivatePipelineResponse.ReadOnly]
  def addTags(
      request: AddTagsRequest
  ): IO[AwsError, zio.aws.datapipeline.model.AddTagsResponse.ReadOnly]
  def describeObjects(
      request: DescribeObjectsRequest
  ): ZStream[Any, AwsError, zio.aws.datapipeline.model.PipelineObject.ReadOnly]
  def describeObjectsPaginated(
      request: DescribeObjectsRequest
  ): IO[AwsError, zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly]
  def reportTaskRunnerHeartbeat(request: ReportTaskRunnerHeartbeatRequest): IO[
    AwsError,
    zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatResponse.ReadOnly
  ]
  def listPipelines(
      request: ListPipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.datapipeline.model.PipelineIdName.ReadOnly]
  def listPipelinesPaginated(
      request: ListPipelinesRequest
  ): IO[AwsError, zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly]
  def putPipelineDefinition(request: PutPipelineDefinitionRequest): IO[
    AwsError,
    zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly
  ]
  def removeTags(
      request: RemoveTagsRequest
  ): IO[AwsError, zio.aws.datapipeline.model.RemoveTagsResponse.ReadOnly]
  def getPipelineDefinition(request: GetPipelineDefinitionRequest): IO[
    AwsError,
    zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly
  ]
  def deactivatePipeline(request: DeactivatePipelineRequest): IO[
    AwsError,
    zio.aws.datapipeline.model.DeactivatePipelineResponse.ReadOnly
  ]
  def setStatus(request: SetStatusRequest): IO[AwsError, Unit]
  def reportTaskProgress(request: ReportTaskProgressRequest): IO[
    AwsError,
    zio.aws.datapipeline.model.ReportTaskProgressResponse.ReadOnly
  ]
  def describePipelines(
      request: DescribePipelinesRequest
  ): IO[AwsError, ReadOnly]
  def deletePipeline(request: DeletePipelineRequest): IO[AwsError, Unit]
  def validatePipelineDefinition(
      request: ValidatePipelineDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly
  ]
  def evaluateExpression(request: EvaluateExpressionRequest): IO[
    AwsError,
    zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly
  ]
  def createPipeline(
      request: CreatePipelineRequest
  ): IO[AwsError, zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly]
  def queryObjects(request: QueryObjectsRequest): ZStream[Any, AwsError, Id]
  def queryObjectsPaginated(
      request: QueryObjectsRequest
  ): IO[AwsError, zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly]
}
object DataPipeline {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DataPipeline] = customized(
    identity
  )
  def customized(
      customization: DataPipelineAsyncClientBuilder => DataPipelineAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DataPipeline] = managed(
    customization
  ).toLayer
  def managed(
      customization: DataPipelineAsyncClientBuilder => DataPipelineAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, DataPipeline] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = DataPipelineAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DataPipelineAsyncClient, DataPipelineAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        DataPipelineAsyncClient,
        DataPipelineAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new DataPipelineImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class DataPipelineImpl[R](
      override val api: DataPipelineAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DataPipeline
      with AwsServiceBase[R] {
    override val serviceName: String = "DataPipeline"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DataPipelineImpl[R1] = new DataPipelineImpl(api, newAspect, r)
    def setTaskStatus(
        request: SetTaskStatusRequest
    ): IO[AwsError, zio.aws.datapipeline.model.SetTaskStatusResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest,
        SetTaskStatusResponse
      ]("setTaskStatus", api.setTaskStatus)(request.buildAwsValue())
        .map(zio.aws.datapipeline.model.SetTaskStatusResponse.wrap)
        .provideEnvironment(r)
    def pollForTask(
        request: PollForTaskRequest
    ): IO[AwsError, zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest,
        PollForTaskResponse
      ]("pollForTask", api.pollForTask)(request.buildAwsValue())
        .map(zio.aws.datapipeline.model.PollForTaskResponse.wrap)
        .provideEnvironment(r)
    def activatePipeline(request: ActivatePipelineRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.ActivatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest,
      ActivatePipelineResponse
    ]("activatePipeline", api.activatePipeline)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.ActivatePipelineResponse.wrap)
      .provideEnvironment(r)
    def addTags(
        request: AddTagsRequest
    ): IO[AwsError, zio.aws.datapipeline.model.AddTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.AddTagsRequest,
        AddTagsResponse
      ]("addTags", api.addTags)(request.buildAwsValue())
        .map(zio.aws.datapipeline.model.AddTagsResponse.wrap)
        .provideEnvironment(r)
    def describeObjects(request: DescribeObjectsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datapipeline.model.PipelineObject.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest,
      PipelineObject,
      DescribeObjectsPublisher
    ]("describeObjects", api.describeObjectsPaginator, _.pipelineObjects())(
      request.buildAwsValue()
    ).map(item => zio.aws.datapipeline.model.PipelineObject.wrap(item))
      .provideEnvironment(r)
    def describeObjectsPaginated(request: DescribeObjectsRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest,
      DescribeObjectsResponse
    ]("describeObjects", api.describeObjects)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.DescribeObjectsResponse.wrap)
      .provideEnvironment(r)
    def reportTaskRunnerHeartbeat(
        request: ReportTaskRunnerHeartbeatRequest
    ): IO[
      AwsError,
      zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest,
      ReportTaskRunnerHeartbeatResponse
    ]("reportTaskRunnerHeartbeat", api.reportTaskRunnerHeartbeat)(
      request.buildAwsValue()
    ).map(zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatResponse.wrap)
      .provideEnvironment(r)
    def listPipelines(request: ListPipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datapipeline.model.PipelineIdName.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest,
      PipelineIdName,
      ListPipelinesPublisher
    ]("listPipelines", api.listPipelinesPaginator, _.pipelineIdList())(
      request.buildAwsValue()
    ).map(item => zio.aws.datapipeline.model.PipelineIdName.wrap(item))
      .provideEnvironment(r)
    def listPipelinesPaginated(
        request: ListPipelinesRequest
    ): IO[AwsError, zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest,
        ListPipelinesResponse
      ]("listPipelines", api.listPipelines)(request.buildAwsValue())
        .map(zio.aws.datapipeline.model.ListPipelinesResponse.wrap)
        .provideEnvironment(r)
    def putPipelineDefinition(request: PutPipelineDefinitionRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionRequest,
      PutPipelineDefinitionResponse
    ]("putPipelineDefinition", api.putPipelineDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.datapipeline.model.PutPipelineDefinitionResponse.wrap)
      .provideEnvironment(r)
    def removeTags(
        request: RemoveTagsRequest
    ): IO[AwsError, zio.aws.datapipeline.model.RemoveTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest,
        RemoveTagsResponse
      ]("removeTags", api.removeTags)(request.buildAwsValue())
        .map(zio.aws.datapipeline.model.RemoveTagsResponse.wrap)
        .provideEnvironment(r)
    def getPipelineDefinition(request: GetPipelineDefinitionRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest,
      GetPipelineDefinitionResponse
    ]("getPipelineDefinition", api.getPipelineDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.datapipeline.model.GetPipelineDefinitionResponse.wrap)
      .provideEnvironment(r)
    def deactivatePipeline(request: DeactivatePipelineRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.DeactivatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest,
      DeactivatePipelineResponse
    ]("deactivatePipeline", api.deactivatePipeline)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.DeactivatePipelineResponse.wrap)
      .provideEnvironment(r)
    def setStatus(request: SetStatusRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.SetStatusRequest,
        SetStatusResponse
      ]("setStatus", api.setStatus)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def reportTaskProgress(request: ReportTaskProgressRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.ReportTaskProgressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest,
      ReportTaskProgressResponse
    ]("reportTaskProgress", api.reportTaskProgress)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.ReportTaskProgressResponse.wrap)
      .provideEnvironment(r)
    def describePipelines(
        request: DescribePipelinesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest,
      DescribePipelinesResponse
    ]("describePipelines", api.describePipelines)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.DescribePipelinesResponse.wrap)
      .provideEnvironment(r)
    def deletePipeline(request: DeletePipelineRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest,
        DeletePipelineResponse
      ]("deletePipeline", api.deletePipeline)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def validatePipelineDefinition(
        request: ValidatePipelineDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest,
      ValidatePipelineDefinitionResponse
    ]("validatePipelineDefinition", api.validatePipelineDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.wrap)
      .provideEnvironment(r)
    def evaluateExpression(request: EvaluateExpressionRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest,
      EvaluateExpressionResponse
    ]("evaluateExpression", api.evaluateExpression)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.EvaluateExpressionResponse.wrap)
      .provideEnvironment(r)
    def createPipeline(request: CreatePipelineRequest): IO[
      AwsError,
      zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest,
      CreatePipelineResponse
    ]("createPipeline", api.createPipeline)(request.buildAwsValue())
      .map(zio.aws.datapipeline.model.CreatePipelineResponse.wrap)
      .provideEnvironment(r)
    def queryObjects(request: QueryObjectsRequest): ZStream[Any, AwsError, Id] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest,
        java.lang.String,
        QueryObjectsPublisher
      ]("queryObjects", api.queryObjectsPaginator, _.ids())(
        request.buildAwsValue()
      ).map(item => zio.aws.datapipeline.model.primitives.Id(item))
        .provideEnvironment(r)
    def queryObjectsPaginated(
        request: QueryObjectsRequest
    ): IO[AwsError, zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest,
        QueryObjectsResponse
      ]("queryObjects", api.queryObjects)(request.buildAwsValue())
        .map(zio.aws.datapipeline.model.QueryObjectsResponse.wrap)
        .provideEnvironment(r)
  }
  def setTaskStatus(request: SetTaskStatusRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.SetTaskStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setTaskStatus(request))
  def pollForTask(request: PollForTaskRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pollForTask(request))
  def activatePipeline(request: ActivatePipelineRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.ActivatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activatePipeline(request))
  def addTags(request: AddTagsRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.AddTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTags(request))
  def describeObjects(request: DescribeObjectsRequest): ZStream[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.PipelineObject.ReadOnly
  ] = ZStream.serviceWithStream(_.describeObjects(request))
  def describeObjectsPaginated(request: DescribeObjectsRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeObjectsPaginated(request))
  def reportTaskRunnerHeartbeat(request: ReportTaskRunnerHeartbeatRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reportTaskRunnerHeartbeat(request))
  def listPipelines(request: ListPipelinesRequest): ZStream[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.PipelineIdName.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelines(request))
  def listPipelinesPaginated(request: ListPipelinesRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelinesPaginated(request))
  def putPipelineDefinition(request: PutPipelineDefinitionRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putPipelineDefinition(request))
  def removeTags(request: RemoveTagsRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.RemoveTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTags(request))
  def getPipelineDefinition(request: GetPipelineDefinitionRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPipelineDefinition(request))
  def deactivatePipeline(request: DeactivatePipelineRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.DeactivatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deactivatePipeline(request))
  def setStatus(
      request: SetStatusRequest
  ): ZIO[zio.aws.datapipeline.DataPipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setStatus(request))
  def reportTaskProgress(request: ReportTaskProgressRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.ReportTaskProgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reportTaskProgress(request))
  def describePipelines(
      request: DescribePipelinesRequest
  ): ZIO[zio.aws.datapipeline.DataPipeline, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describePipelines(request))
  def deletePipeline(
      request: DeletePipelineRequest
  ): ZIO[zio.aws.datapipeline.DataPipeline, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePipeline(request))
  def validatePipelineDefinition(
      request: ValidatePipelineDefinitionRequest
  ): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validatePipelineDefinition(request))
  def evaluateExpression(request: EvaluateExpressionRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.evaluateExpression(request))
  def createPipeline(request: CreatePipelineRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPipeline(request))
  def queryObjects(
      request: QueryObjectsRequest
  ): ZStream[zio.aws.datapipeline.DataPipeline, AwsError, Id] =
    ZStream.serviceWithStream(_.queryObjects(request))
  def queryObjectsPaginated(request: QueryObjectsRequest): ZIO[
    zio.aws.datapipeline.DataPipeline,
    AwsError,
    zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.queryObjectsPaginated(request))
}
