package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class PipelineIdName(
    id: Option[Id] = None,
    name: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PipelineIdName = {
    import PipelineIdName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PipelineIdName
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Id.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.PipelineIdName.ReadOnly =
    zio.aws.datapipeline.model.PipelineIdName.wrap(buildAwsValue())
}
object PipelineIdName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PipelineIdName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PipelineIdName =
      zio.aws.datapipeline.model
        .PipelineIdName(id.map(value => value), name.map(value => value))
    def id: Option[Id]
    def name: Option[Id]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PipelineIdName
  ) extends zio.aws.datapipeline.model.PipelineIdName.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val name: Option[Id] = scala
      .Option(impl.name())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PipelineIdName
  ): zio.aws.datapipeline.model.PipelineIdName.ReadOnly = new Wrapper(impl)
}
