package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.{FieldStringValue, FieldNameString}
import scala.jdk.CollectionConverters.*
final case class ParameterValue(
    id: FieldNameString,
    stringValue: FieldStringValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ParameterValue = {
    import ParameterValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ParameterValue
      .builder()
      .id(FieldNameString.unwrap(id): java.lang.String)
      .stringValue(FieldStringValue.unwrap(stringValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ParameterValue.ReadOnly =
    zio.aws.datapipeline.model.ParameterValue.wrap(buildAwsValue())
}
object ParameterValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ParameterValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ParameterValue =
      zio.aws.datapipeline.model.ParameterValue(id, stringValue)
    def id: FieldNameString
    def stringValue: FieldStringValue
    def getId: ZIO[Any, Nothing, FieldNameString] = ZIO.succeed(id)
    def getStringValue: ZIO[Any, Nothing, FieldStringValue] =
      ZIO.succeed(stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ParameterValue
  ) extends zio.aws.datapipeline.model.ParameterValue.ReadOnly {
    override val id: FieldNameString =
      zio.aws.datapipeline.model.primitives.FieldNameString(impl.id())
    override val stringValue: FieldStringValue =
      zio.aws.datapipeline.model.primitives.FieldStringValue(impl.stringValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ParameterValue
  ): zio.aws.datapipeline.model.ParameterValue.ReadOnly = new Wrapper(impl)
}
