package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class PollForTaskRequest(
    workerGroup: String,
    hostname: Optional[Id] = Optional.Absent,
    instanceIdentity: Optional[zio.aws.datapipeline.model.InstanceIdentity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest = {
    import PollForTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest
      .builder()
      .workerGroup(workerGroup: java.lang.String)
      .optionallyWith(
        hostname.map(value => Id.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(instanceIdentity.map(value => value.buildAwsValue()))(
        _.instanceIdentity
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.PollForTaskRequest.ReadOnly =
    zio.aws.datapipeline.model.PollForTaskRequest.wrap(buildAwsValue())
}
object PollForTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PollForTaskRequest =
      zio.aws.datapipeline.model.PollForTaskRequest(
        workerGroup,
        hostname.map(value => value),
        instanceIdentity.map(value => value.asEditable)
      )
    def workerGroup: String
    def hostname: Optional[Id]
    def instanceIdentity
        : Optional[zio.aws.datapipeline.model.InstanceIdentity.ReadOnly]
    def getWorkerGroup: ZIO[Any, Nothing, String] = ZIO.succeed(workerGroup)
    def getHostname: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getInstanceIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.datapipeline.model.InstanceIdentity.ReadOnly
    ] = AwsError.unwrapOptionField("instanceIdentity", instanceIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest
  ) extends zio.aws.datapipeline.model.PollForTaskRequest.ReadOnly {
    override val workerGroup: String = impl.workerGroup(): String
    override val hostname: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val instanceIdentity
        : Optional[zio.aws.datapipeline.model.InstanceIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceIdentity())
        .map(value => zio.aws.datapipeline.model.InstanceIdentity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest
  ): zio.aws.datapipeline.model.PollForTaskRequest.ReadOnly = new Wrapper(impl)
}
