package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Query(
    selectors: Optional[Iterable[zio.aws.datapipeline.model.Selector]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.Query = {
    import Query.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.Query
      .builder()
      .optionallyWith(
        selectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectors)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.Query.ReadOnly =
    zio.aws.datapipeline.model.Query.wrap(buildAwsValue())
}
object Query {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.Query
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.Query =
      zio.aws.datapipeline.model.Query(
        selectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def selectors: Optional[List[zio.aws.datapipeline.model.Selector.ReadOnly]]
    def getSelectors: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.Selector.ReadOnly
    ]] = AwsError.unwrapOptionField("selectors", selectors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.Query
  ) extends zio.aws.datapipeline.model.Query.ReadOnly {
    override val selectors
        : Optional[List[zio.aws.datapipeline.model.Selector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.Selector.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.Query
  ): zio.aws.datapipeline.model.Query.ReadOnly = new Wrapper(impl)
}
